package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ContainerServiceProtocol { def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol }
object ContainerServiceProtocol {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol): ContainerServiceProtocol = value match {
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.HTTPS =>
      val r = HTTPS
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.TCP =>
      val r = TCP
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.UDP =>
      val r = UDP
      r
  }
  case object unknownToSdkVersion extends ContainerServiceProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol = software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.UNKNOWN_TO_SDK_VERSION }
  case object HTTP extends ContainerServiceProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol = software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.HTTP }
  case object HTTPS extends ContainerServiceProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol = software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.HTTPS }
  case object TCP extends ContainerServiceProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol = software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.TCP }
  case object UDP extends ContainerServiceProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol = software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.UDP }
}