package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CloseInstancePublicPortsRequest(portInfo: PortInfo, instanceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest = {
    import CloseInstancePublicPortsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest.builder().portInfo(portInfo.buildAwsValue()).instanceName(instanceName: java.lang.String).build()
  }
  def asReadOnly: CloseInstancePublicPortsRequest.ReadOnly = CloseInstancePublicPortsRequest.wrap(buildAwsValue())
}
object CloseInstancePublicPortsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CloseInstancePublicPortsRequest = CloseInstancePublicPortsRequest(portInfoValue.editable, instanceNameValue)
    def portInfoValue: PortInfo.ReadOnly
    def instanceNameValue: primitives.ResourceName
    def portInfo: ZIO[Any, Nothing, PortInfo.ReadOnly] = ZIO.succeed(portInfoValue)
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest) extends CloseInstancePublicPortsRequest.ReadOnly {
    override def portInfoValue: PortInfo.ReadOnly = PortInfo.wrap(impl.portInfo())
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest): ReadOnly = new Wrapper(impl)
}