package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait AddOnType { def unwrap: software.amazon.awssdk.services.lightsail.model.AddOnType }
object AddOnType {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.AddOnType): AddOnType = value match {
    case software.amazon.awssdk.services.lightsail.model.AddOnType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AddOnType.AUTO_SNAPSHOT =>
      val r = AutoSnapshot
      r
  }
  case object unknownToSdkVersion extends AddOnType { override def unwrap: software.amazon.awssdk.services.lightsail.model.AddOnType = software.amazon.awssdk.services.lightsail.model.AddOnType.UNKNOWN_TO_SDK_VERSION }
  case object AutoSnapshot extends AddOnType { override def unwrap: software.amazon.awssdk.services.lightsail.model.AddOnType = software.amazon.awssdk.services.lightsail.model.AddOnType.AUTO_SNAPSHOT }
}