package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateDistributionRequest(distributionName: primitives.ResourceName, origin: scala.Option[InputOrigin] = None, defaultCacheBehavior: scala.Option[CacheBehavior] = None, cacheBehaviorSettings: scala.Option[CacheSettings] = None, cacheBehaviors: scala.Option[Iterable[CacheBehaviorPerPath]] = None, isEnabled: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest = {
    import UpdateDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest.builder().distributionName(distributionName: java.lang.String).optionallyWith(origin.map(value => value.buildAwsValue()))(_.origin).optionallyWith(defaultCacheBehavior.map(value => value.buildAwsValue()))(_.defaultCacheBehavior).optionallyWith(cacheBehaviorSettings.map(value => value.buildAwsValue()))(_.cacheBehaviorSettings).optionallyWith(cacheBehaviors.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.cacheBehaviors).optionallyWith(isEnabled.map(value => value: java.lang.Boolean))(_.isEnabled).build()
  }
  def asReadOnly: UpdateDistributionRequest.ReadOnly = UpdateDistributionRequest.wrap(buildAwsValue())
}
object UpdateDistributionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateDistributionRequest = UpdateDistributionRequest(distributionNameValue, originValue.map(value => value.editable), defaultCacheBehaviorValue.map(value => value.editable), cacheBehaviorSettingsValue.map(value => value.editable), cacheBehaviorsValue.map(value => value.map { item => 
      item.editable
    }), isEnabledValue.map(value => value))
    def distributionNameValue: primitives.ResourceName
    def originValue: scala.Option[InputOrigin.ReadOnly]
    def defaultCacheBehaviorValue: scala.Option[CacheBehavior.ReadOnly]
    def cacheBehaviorSettingsValue: scala.Option[CacheSettings.ReadOnly]
    def cacheBehaviorsValue: scala.Option[List[CacheBehaviorPerPath.ReadOnly]]
    def isEnabledValue: scala.Option[Boolean]
    def distributionName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(distributionNameValue)
    def origin: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InputOrigin.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("origin", originValue)
    def defaultCacheBehavior: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CacheBehavior.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultCacheBehavior", defaultCacheBehaviorValue)
    def cacheBehaviorSettings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CacheSettings.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cacheBehaviorSettings", cacheBehaviorSettingsValue)
    def cacheBehaviors: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CacheBehaviorPerPath.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviorsValue)
    def isEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isEnabled", isEnabledValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest) extends UpdateDistributionRequest.ReadOnly {
    override def distributionNameValue: primitives.ResourceName = impl.distributionName(): primitives.ResourceName
    override def originValue: scala.Option[InputOrigin.ReadOnly] = scala.Option(impl.origin()).map(value => InputOrigin.wrap(value))
    override def defaultCacheBehaviorValue: scala.Option[CacheBehavior.ReadOnly] = scala.Option(impl.defaultCacheBehavior()).map(value => CacheBehavior.wrap(value))
    override def cacheBehaviorSettingsValue: scala.Option[CacheSettings.ReadOnly] = scala.Option(impl.cacheBehaviorSettings()).map(value => CacheSettings.wrap(value))
    override def cacheBehaviorsValue: scala.Option[List[CacheBehaviorPerPath.ReadOnly]] = scala.Option(impl.cacheBehaviors()).map(value => value.asScala.map { item => 
      CacheBehaviorPerPath.wrap(item)
    }.toList)
    override def isEnabledValue: scala.Option[Boolean] = scala.Option(impl.isEnabled()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionRequest): ReadOnly = new Wrapper(impl)
}