package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UntagResourceRequest(resourceName: primitives.ResourceName, resourceArn: scala.Option[primitives.ResourceArn] = None, tagKeys: Iterable[primitives.TagKey]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UntagResourceRequest.builder().resourceName(resourceName: java.lang.String).optionallyWith(resourceArn.map(value => value: java.lang.String))(_.resourceArn).tagKeys(tagKeys.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: UntagResourceRequest.ReadOnly = UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UntagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UntagResourceRequest = UntagResourceRequest(resourceNameValue, resourceArnValue.map(value => value), tagKeysValue)
    def resourceNameValue: primitives.ResourceName
    def resourceArnValue: scala.Option[primitives.ResourceArn]
    def tagKeysValue: List[primitives.TagKey]
    def resourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(resourceNameValue)
    def resourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceArn", resourceArnValue)
    def tagKeys: ZIO[Any, Nothing, List[primitives.TagKey]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UntagResourceRequest) extends UntagResourceRequest.ReadOnly {
    override def resourceNameValue: primitives.ResourceName = impl.resourceName(): primitives.ResourceName
    override def resourceArnValue: scala.Option[primitives.ResourceArn] = scala.Option(impl.resourceArn()).map(value => value: primitives.ResourceArn)
    override def tagKeysValue: List[primitives.TagKey] = impl.tagKeys().asScala.map { item => 
      item: primitives.TagKey
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UntagResourceRequest): ReadOnly = new Wrapper(impl)
}