package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait StatusType { def unwrap: software.amazon.awssdk.services.lightsail.model.StatusType }
object StatusType {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.StatusType): StatusType = value match {
    case software.amazon.awssdk.services.lightsail.model.StatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.StatusType.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.lightsail.model.StatusType.INACTIVE =>
      val r = Inactive
      r
  }
  case object unknownToSdkVersion extends StatusType { override def unwrap: software.amazon.awssdk.services.lightsail.model.StatusType = software.amazon.awssdk.services.lightsail.model.StatusType.UNKNOWN_TO_SDK_VERSION }
  case object Active extends StatusType { override def unwrap: software.amazon.awssdk.services.lightsail.model.StatusType = software.amazon.awssdk.services.lightsail.model.StatusType.ACTIVE }
  case object Inactive extends StatusType { override def unwrap: software.amazon.awssdk.services.lightsail.model.StatusType = software.amazon.awssdk.services.lightsail.model.StatusType.INACTIVE }
}