package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SetResourceAccessForBucketRequest(resourceName: primitives.ResourceName, bucketName: primitives.BucketName, access: ResourceBucketAccess) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest = {
    import SetResourceAccessForBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest.builder().resourceName(resourceName: java.lang.String).bucketName(bucketName: java.lang.String).access(access.unwrap).build()
  }
  def asReadOnly: SetResourceAccessForBucketRequest.ReadOnly = SetResourceAccessForBucketRequest.wrap(buildAwsValue())
}
object SetResourceAccessForBucketRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SetResourceAccessForBucketRequest = SetResourceAccessForBucketRequest(resourceNameValue, bucketNameValue, accessValue)
    def resourceNameValue: primitives.ResourceName
    def bucketNameValue: primitives.BucketName
    def accessValue: ResourceBucketAccess
    def resourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(resourceNameValue)
    def bucketName: ZIO[Any, Nothing, primitives.BucketName] = ZIO.succeed(bucketNameValue)
    def access: ZIO[Any, Nothing, ResourceBucketAccess] = ZIO.succeed(accessValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest) extends SetResourceAccessForBucketRequest.ReadOnly {
    override def resourceNameValue: primitives.ResourceName = impl.resourceName(): primitives.ResourceName
    override def bucketNameValue: primitives.BucketName = impl.bucketName(): primitives.BucketName
    override def accessValue: ResourceBucketAccess = ResourceBucketAccess.wrap(impl.access())
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest): ReadOnly = new Wrapper(impl)
}