package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RelationalDatabaseEndpoint(port: scala.Option[primitives.Integer] = None, address: scala.Option[primitives.NonEmptyString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint = {
    import RelationalDatabaseEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint.builder().optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(address.map(value => value: java.lang.String))(_.address).build()
  }
  def asReadOnly: RelationalDatabaseEndpoint.ReadOnly = RelationalDatabaseEndpoint.wrap(buildAwsValue())
}
object RelationalDatabaseEndpoint {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RelationalDatabaseEndpoint = RelationalDatabaseEndpoint(portValue.map(value => value), addressValue.map(value => value))
    def portValue: scala.Option[primitives.Integer]
    def addressValue: scala.Option[primitives.NonEmptyString]
    def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
    def address: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("address", addressValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint) extends RelationalDatabaseEndpoint.ReadOnly {
    override def portValue: scala.Option[primitives.Integer] = scala.Option(impl.port()).map(value => value: primitives.Integer)
    override def addressValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.address()).map(value => value: primitives.NonEmptyString)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint): ReadOnly = new Wrapper(impl)
}