package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RebootRelationalDatabaseRequest(relationalDatabaseName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest = {
    import RebootRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).build()
  }
  def asReadOnly: RebootRelationalDatabaseRequest.ReadOnly = RebootRelationalDatabaseRequest.wrap(buildAwsValue())
}
object RebootRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RebootRelationalDatabaseRequest = RebootRelationalDatabaseRequest(relationalDatabaseNameValue)
    def relationalDatabaseNameValue: primitives.ResourceName
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest) extends RebootRelationalDatabaseRequest.ReadOnly { override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest): ReadOnly = new Wrapper(impl)
}