package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PutAlarmRequest(alarmName: primitives.ResourceName, metricName: MetricName, monitoredResourceName: primitives.ResourceName, comparisonOperator: ComparisonOperator, threshold: Double, evaluationPeriods: primitives.Integer, datapointsToAlarm: scala.Option[primitives.Integer] = None, treatMissingData: scala.Option[TreatMissingData] = None, contactProtocols: scala.Option[Iterable[ContactProtocol]] = None, notificationTriggers: scala.Option[Iterable[AlarmState]] = None, notificationEnabled: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.PutAlarmRequest = {
    import PutAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PutAlarmRequest.builder().alarmName(alarmName: java.lang.String).metricName(metricName.unwrap).monitoredResourceName(monitoredResourceName: java.lang.String).comparisonOperator(comparisonOperator.unwrap).threshold(threshold: java.lang.Double).evaluationPeriods(evaluationPeriods: java.lang.Integer).optionallyWith(datapointsToAlarm.map(value => value: java.lang.Integer))(_.datapointsToAlarm).optionallyWith(treatMissingData.map(value => value.unwrap))(_.treatMissingData).optionallyWith(contactProtocols.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.contactProtocolsWithStrings).optionallyWith(notificationTriggers.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.notificationTriggersWithStrings).optionallyWith(notificationEnabled.map(value => value: java.lang.Boolean))(_.notificationEnabled).build()
  }
  def asReadOnly: PutAlarmRequest.ReadOnly = PutAlarmRequest.wrap(buildAwsValue())
}
object PutAlarmRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.PutAlarmRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PutAlarmRequest = PutAlarmRequest(alarmNameValue, metricNameValue, monitoredResourceNameValue, comparisonOperatorValue, thresholdValue, evaluationPeriodsValue, datapointsToAlarmValue.map(value => value), treatMissingDataValue.map(value => value), contactProtocolsValue.map(value => value), notificationTriggersValue.map(value => value), notificationEnabledValue.map(value => value))
    def alarmNameValue: primitives.ResourceName
    def metricNameValue: MetricName
    def monitoredResourceNameValue: primitives.ResourceName
    def comparisonOperatorValue: ComparisonOperator
    def thresholdValue: Double
    def evaluationPeriodsValue: primitives.Integer
    def datapointsToAlarmValue: scala.Option[primitives.Integer]
    def treatMissingDataValue: scala.Option[TreatMissingData]
    def contactProtocolsValue: scala.Option[List[ContactProtocol]]
    def notificationTriggersValue: scala.Option[List[AlarmState]]
    def notificationEnabledValue: scala.Option[Boolean]
    def alarmName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(alarmNameValue)
    def metricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricNameValue)
    def monitoredResourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(monitoredResourceNameValue)
    def comparisonOperator: ZIO[Any, Nothing, ComparisonOperator] = ZIO.succeed(comparisonOperatorValue)
    def threshold: ZIO[Any, Nothing, Double] = ZIO.succeed(thresholdValue)
    def evaluationPeriods: ZIO[Any, Nothing, primitives.Integer] = ZIO.succeed(evaluationPeriodsValue)
    def datapointsToAlarm: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("datapointsToAlarm", datapointsToAlarmValue)
    def treatMissingData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TreatMissingData] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("treatMissingData", treatMissingDataValue)
    def contactProtocols: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ContactProtocol]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("contactProtocols", contactProtocolsValue)
    def notificationTriggers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AlarmState]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notificationTriggers", notificationTriggersValue)
    def notificationEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notificationEnabled", notificationEnabledValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.PutAlarmRequest) extends PutAlarmRequest.ReadOnly {
    override def alarmNameValue: primitives.ResourceName = impl.alarmName(): primitives.ResourceName
    override def metricNameValue: MetricName = MetricName.wrap(impl.metricName())
    override def monitoredResourceNameValue: primitives.ResourceName = impl.monitoredResourceName(): primitives.ResourceName
    override def comparisonOperatorValue: ComparisonOperator = ComparisonOperator.wrap(impl.comparisonOperator())
    override def thresholdValue: Double = impl.threshold(): Double
    override def evaluationPeriodsValue: primitives.Integer = impl.evaluationPeriods(): primitives.Integer
    override def datapointsToAlarmValue: scala.Option[primitives.Integer] = scala.Option(impl.datapointsToAlarm()).map(value => value: primitives.Integer)
    override def treatMissingDataValue: scala.Option[TreatMissingData] = scala.Option(impl.treatMissingData()).map(value => TreatMissingData.wrap(value))
    override def contactProtocolsValue: scala.Option[List[ContactProtocol]] = scala.Option(impl.contactProtocols()).map(value => value.asScala.map { item => 
      ContactProtocol.wrap(item)
    }.toList)
    override def notificationTriggersValue: scala.Option[List[AlarmState]] = scala.Option(impl.notificationTriggers()).map(value => value.asScala.map { item => 
      AlarmState.wrap(item)
    }.toList)
    override def notificationEnabledValue: scala.Option[Boolean] = scala.Option(impl.notificationEnabled()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.PutAlarmRequest): ReadOnly = new Wrapper(impl)
}