package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait LoadBalancerTlsCertificateRenewalStatus { def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus }
object LoadBalancerTlsCertificateRenewalStatus {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus): LoadBalancerTlsCertificateRenewalStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.PENDING_AUTO_RENEWAL =>
      val r = PENDING_AUTO_RENEWAL
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.PENDING_VALIDATION =>
      val r = PENDING_VALIDATION
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends LoadBalancerTlsCertificateRenewalStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.UNKNOWN_TO_SDK_VERSION }
  case object PENDING_AUTO_RENEWAL extends LoadBalancerTlsCertificateRenewalStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.PENDING_AUTO_RENEWAL }
  case object PENDING_VALIDATION extends LoadBalancerTlsCertificateRenewalStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.PENDING_VALIDATION }
  case object SUCCESS extends LoadBalancerTlsCertificateRenewalStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.SUCCESS }
  case object FAILED extends LoadBalancerTlsCertificateRenewalStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalStatus.FAILED }
}