package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class IsVpcPeeredResponse(isPeered: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse = {
    import IsVpcPeeredResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse.builder().optionallyWith(isPeered.map(value => value: java.lang.Boolean))(_.isPeered).build()
  }
  def asReadOnly: IsVpcPeeredResponse.ReadOnly = IsVpcPeeredResponse.wrap(buildAwsValue())
}
object IsVpcPeeredResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: IsVpcPeeredResponse = IsVpcPeeredResponse(isPeeredValue.map(value => value))
    def isPeeredValue: scala.Option[Boolean]
    def isPeered: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isPeered", isPeeredValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse) extends IsVpcPeeredResponse.ReadOnly { override def isPeeredValue: scala.Option[Boolean] = scala.Option(impl.isPeered()).map(value => value: Boolean) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse): ReadOnly = new Wrapper(impl)
}