package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstanceEntry(sourceName: primitives.ResourceName, instanceType: primitives.NonEmptyString, portInfoSource: PortInfoSourceType, userData: scala.Option[String] = None, availabilityZone: String) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstanceEntry = {
    import InstanceEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceEntry.builder().sourceName(sourceName: java.lang.String).instanceType(instanceType: java.lang.String).portInfoSource(portInfoSource.unwrap).optionallyWith(userData.map(value => value: java.lang.String))(_.userData).availabilityZone(availabilityZone: java.lang.String).build()
  }
  def asReadOnly: InstanceEntry.ReadOnly = InstanceEntry.wrap(buildAwsValue())
}
object InstanceEntry {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstanceEntry] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstanceEntry = InstanceEntry(sourceNameValue, instanceTypeValue, portInfoSourceValue, userDataValue.map(value => value), availabilityZoneValue)
    def sourceNameValue: primitives.ResourceName
    def instanceTypeValue: primitives.NonEmptyString
    def portInfoSourceValue: PortInfoSourceType
    def userDataValue: scala.Option[String]
    def availabilityZoneValue: String
    def sourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(sourceNameValue)
    def instanceType: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(instanceTypeValue)
    def portInfoSource: ZIO[Any, Nothing, PortInfoSourceType] = ZIO.succeed(portInfoSourceValue)
    def userData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("userData", userDataValue)
    def availabilityZone: ZIO[Any, Nothing, String] = ZIO.succeed(availabilityZoneValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstanceEntry) extends InstanceEntry.ReadOnly {
    override def sourceNameValue: primitives.ResourceName = impl.sourceName(): primitives.ResourceName
    override def instanceTypeValue: primitives.NonEmptyString = impl.instanceType(): primitives.NonEmptyString
    override def portInfoSourceValue: PortInfoSourceType = PortInfoSourceType.wrap(impl.portInfoSource())
    override def userDataValue: scala.Option[String] = scala.Option(impl.userData()).map(value => value: String)
    override def availabilityZoneValue: String = impl.availabilityZone(): String
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstanceEntry): ReadOnly = new Wrapper(impl)
}