package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabasesResponse(relationalDatabases: scala.Option[Iterable[RelationalDatabase]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse = {
    import GetRelationalDatabasesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse.builder().optionallyWith(relationalDatabases.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.relationalDatabases).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetRelationalDatabasesResponse.ReadOnly = GetRelationalDatabasesResponse.wrap(buildAwsValue())
}
object GetRelationalDatabasesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabasesResponse = GetRelationalDatabasesResponse(relationalDatabasesValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def relationalDatabasesValue: scala.Option[List[RelationalDatabase.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def relationalDatabases: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RelationalDatabase.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabases", relationalDatabasesValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse) extends GetRelationalDatabasesResponse.ReadOnly {
    override def relationalDatabasesValue: scala.Option[List[RelationalDatabase.ReadOnly]] = scala.Option(impl.relationalDatabases()).map(value => value.asScala.map { item => 
      RelationalDatabase.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabasesResponse): ReadOnly = new Wrapper(impl)
}