package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseSnapshotRequest(relationalDatabaseSnapshotName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest = {
    import GetRelationalDatabaseSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest.builder().relationalDatabaseSnapshotName(relationalDatabaseSnapshotName: java.lang.String).build()
  }
  def asReadOnly: GetRelationalDatabaseSnapshotRequest.ReadOnly = GetRelationalDatabaseSnapshotRequest.wrap(buildAwsValue())
}
object GetRelationalDatabaseSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseSnapshotRequest = GetRelationalDatabaseSnapshotRequest(relationalDatabaseSnapshotNameValue)
    def relationalDatabaseSnapshotNameValue: primitives.ResourceName
    def relationalDatabaseSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseSnapshotNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest) extends GetRelationalDatabaseSnapshotRequest.ReadOnly { override def relationalDatabaseSnapshotNameValue: primitives.ResourceName = impl.relationalDatabaseSnapshotName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest): ReadOnly = new Wrapper(impl)
}