package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLoadBalancerMetricDataResponse(metricName: scala.Option[LoadBalancerMetricName] = None, metricData: scala.Option[Iterable[MetricDatapoint]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse = {
    import GetLoadBalancerMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse.builder().optionallyWith(metricName.map(value => value.unwrap))(_.metricName).optionallyWith(metricData.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.metricData).build()
  }
  def asReadOnly: GetLoadBalancerMetricDataResponse.ReadOnly = GetLoadBalancerMetricDataResponse.wrap(buildAwsValue())
}
object GetLoadBalancerMetricDataResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLoadBalancerMetricDataResponse = GetLoadBalancerMetricDataResponse(metricNameValue.map(value => value), metricDataValue.map(value => value.map { item => 
      item.editable
    }))
    def metricNameValue: scala.Option[LoadBalancerMetricName]
    def metricDataValue: scala.Option[List[MetricDatapoint.ReadOnly]]
    def metricName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, LoadBalancerMetricName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metricName", metricNameValue)
    def metricData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[MetricDatapoint.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("metricData", metricDataValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse) extends GetLoadBalancerMetricDataResponse.ReadOnly {
    override def metricNameValue: scala.Option[LoadBalancerMetricName] = scala.Option(impl.metricName()).map(value => LoadBalancerMetricName.wrap(value))
    override def metricDataValue: scala.Option[List[MetricDatapoint.ReadOnly]] = scala.Option(impl.metricData()).map(value => value.asScala.map { item => 
      MetricDatapoint.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerMetricDataResponse): ReadOnly = new Wrapper(impl)
}