package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerServiceMetricDataRequest(serviceName: primitives.ContainerServiceName, metricName: ContainerServiceMetricName, startTime: primitives.IsoDate, endTime: primitives.IsoDate, period: primitives.MetricPeriod, statistics: Iterable[MetricStatistic]) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest = {
    import GetContainerServiceMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest.builder().serviceName(serviceName: java.lang.String).metricName(metricName.unwrap).startTime(startTime: java.time.Instant).endTime(endTime: java.time.Instant).period(period: java.lang.Integer).statisticsWithStrings(statistics.map { item => 
      item.unwrap.toString
    }.asJavaCollection).build()
  }
  def asReadOnly: GetContainerServiceMetricDataRequest.ReadOnly = GetContainerServiceMetricDataRequest.wrap(buildAwsValue())
}
object GetContainerServiceMetricDataRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerServiceMetricDataRequest = GetContainerServiceMetricDataRequest(serviceNameValue, metricNameValue, startTimeValue, endTimeValue, periodValue, statisticsValue)
    def serviceNameValue: primitives.ContainerServiceName
    def metricNameValue: ContainerServiceMetricName
    def startTimeValue: primitives.IsoDate
    def endTimeValue: primitives.IsoDate
    def periodValue: primitives.MetricPeriod
    def statisticsValue: List[MetricStatistic]
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
    def metricName: ZIO[Any, Nothing, ContainerServiceMetricName] = ZIO.succeed(metricNameValue)
    def startTime: ZIO[Any, Nothing, primitives.IsoDate] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, primitives.IsoDate] = ZIO.succeed(endTimeValue)
    def period: ZIO[Any, Nothing, primitives.MetricPeriod] = ZIO.succeed(periodValue)
    def statistics: ZIO[Any, Nothing, List[MetricStatistic]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest) extends GetContainerServiceMetricDataRequest.ReadOnly {
    override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName
    override def metricNameValue: ContainerServiceMetricName = ContainerServiceMetricName.wrap(impl.metricName())
    override def startTimeValue: primitives.IsoDate = impl.startTime(): primitives.IsoDate
    override def endTimeValue: primitives.IsoDate = impl.endTime(): primitives.IsoDate
    override def periodValue: primitives.MetricPeriod = impl.period(): primitives.MetricPeriod
    override def statisticsValue: List[MetricStatistic] = impl.statistics().asScala.map { item => 
      MetricStatistic.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest): ReadOnly = new Wrapper(impl)
}