package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBucketsResponse(buckets: scala.Option[Iterable[Bucket]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBucketsResponse = {
    import GetBucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketsResponse.builder().optionallyWith(buckets.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.buckets).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetBucketsResponse.ReadOnly = GetBucketsResponse.wrap(buildAwsValue())
}
object GetBucketsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBucketsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBucketsResponse = GetBucketsResponse(bucketsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def bucketsValue: scala.Option[List[Bucket.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def buckets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Bucket.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("buckets", bucketsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBucketsResponse) extends GetBucketsResponse.ReadOnly {
    override def bucketsValue: scala.Option[List[Bucket.ReadOnly]] = scala.Option(impl.buckets()).map(value => value.asScala.map { item => 
      Bucket.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBucketsResponse): ReadOnly = new Wrapper(impl)
}