package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBucketMetricDataRequest(bucketName: primitives.BucketName, metricName: BucketMetricName, startTime: primitives.IsoDate, endTime: primitives.IsoDate, period: primitives.MetricPeriod, statistics: Iterable[MetricStatistic], unit: MetricUnit) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest = {
    import GetBucketMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest.builder().bucketName(bucketName: java.lang.String).metricName(metricName.unwrap).startTime(startTime: java.time.Instant).endTime(endTime: java.time.Instant).period(period: java.lang.Integer).statisticsWithStrings(statistics.map { item => 
      item.unwrap.toString
    }.asJavaCollection).unit(unit.unwrap).build()
  }
  def asReadOnly: GetBucketMetricDataRequest.ReadOnly = GetBucketMetricDataRequest.wrap(buildAwsValue())
}
object GetBucketMetricDataRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBucketMetricDataRequest = GetBucketMetricDataRequest(bucketNameValue, metricNameValue, startTimeValue, endTimeValue, periodValue, statisticsValue, unitValue)
    def bucketNameValue: primitives.BucketName
    def metricNameValue: BucketMetricName
    def startTimeValue: primitives.IsoDate
    def endTimeValue: primitives.IsoDate
    def periodValue: primitives.MetricPeriod
    def statisticsValue: List[MetricStatistic]
    def unitValue: MetricUnit
    def bucketName: ZIO[Any, Nothing, primitives.BucketName] = ZIO.succeed(bucketNameValue)
    def metricName: ZIO[Any, Nothing, BucketMetricName] = ZIO.succeed(metricNameValue)
    def startTime: ZIO[Any, Nothing, primitives.IsoDate] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, primitives.IsoDate] = ZIO.succeed(endTimeValue)
    def period: ZIO[Any, Nothing, primitives.MetricPeriod] = ZIO.succeed(periodValue)
    def statistics: ZIO[Any, Nothing, List[MetricStatistic]] = ZIO.succeed(statisticsValue)
    def unit: ZIO[Any, Nothing, MetricUnit] = ZIO.succeed(unitValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest) extends GetBucketMetricDataRequest.ReadOnly {
    override def bucketNameValue: primitives.BucketName = impl.bucketName(): primitives.BucketName
    override def metricNameValue: BucketMetricName = BucketMetricName.wrap(impl.metricName())
    override def startTimeValue: primitives.IsoDate = impl.startTime(): primitives.IsoDate
    override def endTimeValue: primitives.IsoDate = impl.endTime(): primitives.IsoDate
    override def periodValue: primitives.MetricPeriod = impl.period(): primitives.MetricPeriod
    override def statisticsValue: List[MetricStatistic] = impl.statistics().asScala.map { item => 
      MetricStatistic.wrap(item)
    }.toList
    override def unitValue: MetricUnit = MetricUnit.wrap(impl.unit())
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBucketMetricDataRequest): ReadOnly = new Wrapper(impl)
}