package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EndpointRequest(containerName: String, containerPort: primitives.Integer, healthCheck: scala.Option[ContainerServiceHealthCheckConfig] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.EndpointRequest = {
    import EndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.EndpointRequest.builder().containerName(containerName: java.lang.String).containerPort(containerPort: java.lang.Integer).optionallyWith(healthCheck.map(value => value.buildAwsValue()))(_.healthCheck).build()
  }
  def asReadOnly: EndpointRequest.ReadOnly = EndpointRequest.wrap(buildAwsValue())
}
object EndpointRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.EndpointRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EndpointRequest = EndpointRequest(containerNameValue, containerPortValue, healthCheckValue.map(value => value.editable))
    def containerNameValue: String
    def containerPortValue: primitives.Integer
    def healthCheckValue: scala.Option[ContainerServiceHealthCheckConfig.ReadOnly]
    def containerName: ZIO[Any, Nothing, String] = ZIO.succeed(containerNameValue)
    def containerPort: ZIO[Any, Nothing, primitives.Integer] = ZIO.succeed(containerPortValue)
    def healthCheck: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceHealthCheckConfig.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("healthCheck", healthCheckValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.EndpointRequest) extends EndpointRequest.ReadOnly {
    override def containerNameValue: String = impl.containerName(): String
    override def containerPortValue: primitives.Integer = impl.containerPort(): primitives.Integer
    override def healthCheckValue: scala.Option[ContainerServiceHealthCheckConfig.ReadOnly] = scala.Option(impl.healthCheck()).map(value => ContainerServiceHealthCheckConfig.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.EndpointRequest): ReadOnly = new Wrapper(impl)
}