package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DetachCertificateFromDistributionRequest(distributionName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest = {
    import DetachCertificateFromDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest.builder().distributionName(distributionName: java.lang.String).build()
  }
  def asReadOnly: DetachCertificateFromDistributionRequest.ReadOnly = DetachCertificateFromDistributionRequest.wrap(buildAwsValue())
}
object DetachCertificateFromDistributionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DetachCertificateFromDistributionRequest = DetachCertificateFromDistributionRequest(distributionNameValue)
    def distributionNameValue: primitives.ResourceName
    def distributionName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(distributionNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest) extends DetachCertificateFromDistributionRequest.ReadOnly { override def distributionNameValue: primitives.ResourceName = impl.distributionName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DetachCertificateFromDistributionRequest): ReadOnly = new Wrapper(impl)
}