package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteLoadBalancerTlsCertificateRequest(loadBalancerName: primitives.ResourceName, certificateName: primitives.ResourceName, force: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest = {
    import DeleteLoadBalancerTlsCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).certificateName(certificateName: java.lang.String).optionallyWith(force.map(value => value: java.lang.Boolean))(_.force).build()
  }
  def asReadOnly: DeleteLoadBalancerTlsCertificateRequest.ReadOnly = DeleteLoadBalancerTlsCertificateRequest.wrap(buildAwsValue())
}
object DeleteLoadBalancerTlsCertificateRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteLoadBalancerTlsCertificateRequest = DeleteLoadBalancerTlsCertificateRequest(loadBalancerNameValue, certificateNameValue, forceValue.map(value => value))
    def loadBalancerNameValue: primitives.ResourceName
    def certificateNameValue: primitives.ResourceName
    def forceValue: scala.Option[Boolean]
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
    def certificateName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(certificateNameValue)
    def force: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("force", forceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest) extends DeleteLoadBalancerTlsCertificateRequest.ReadOnly {
    override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName
    override def certificateNameValue: primitives.ResourceName = impl.certificateName(): primitives.ResourceName
    override def forceValue: scala.Option[Boolean] = scala.Option(impl.force()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerTlsCertificateRequest): ReadOnly = new Wrapper(impl)
}