package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteBucketAccessKeyRequest(bucketName: primitives.BucketName, accessKeyId: primitives.NonEmptyString) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest = {
    import DeleteBucketAccessKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest.builder().bucketName(bucketName: java.lang.String).accessKeyId(accessKeyId: java.lang.String).build()
  }
  def asReadOnly: DeleteBucketAccessKeyRequest.ReadOnly = DeleteBucketAccessKeyRequest.wrap(buildAwsValue())
}
object DeleteBucketAccessKeyRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteBucketAccessKeyRequest = DeleteBucketAccessKeyRequest(bucketNameValue, accessKeyIdValue)
    def bucketNameValue: primitives.BucketName
    def accessKeyIdValue: primitives.NonEmptyString
    def bucketName: ZIO[Any, Nothing, primitives.BucketName] = ZIO.succeed(bucketNameValue)
    def accessKeyId: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(accessKeyIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest) extends DeleteBucketAccessKeyRequest.ReadOnly {
    override def bucketNameValue: primitives.BucketName = impl.bucketName(): primitives.BucketName
    override def accessKeyIdValue: primitives.NonEmptyString = impl.accessKeyId(): primitives.NonEmptyString
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest): ReadOnly = new Wrapper(impl)
}