package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CookieObject(option: scala.Option[ForwardValues] = None, cookiesAllowList: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CookieObject = {
    import CookieObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CookieObject.builder().optionallyWith(option.map(value => value.unwrap))(_.option).optionallyWith(cookiesAllowList.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.cookiesAllowList).build()
  }
  def asReadOnly: CookieObject.ReadOnly = CookieObject.wrap(buildAwsValue())
}
object CookieObject {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CookieObject] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CookieObject = CookieObject(optionValue.map(value => value), cookiesAllowListValue.map(value => value))
    def optionValue: scala.Option[ForwardValues]
    def cookiesAllowListValue: scala.Option[List[String]]
    def option: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ForwardValues] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("option", optionValue)
    def cookiesAllowList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cookiesAllowList", cookiesAllowListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CookieObject) extends CookieObject.ReadOnly {
    override def optionValue: scala.Option[ForwardValues] = scala.Option(impl.option()).map(value => ForwardValues.wrap(value))
    override def cookiesAllowListValue: scala.Option[List[String]] = scala.Option(impl.cookiesAllowList()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CookieObject): ReadOnly = new Wrapper(impl)
}