package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContainerService(containerServiceName: scala.Option[primitives.ContainerServiceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, tags: scala.Option[Iterable[Tag]] = None, power: scala.Option[ContainerServicePowerName] = None, powerId: scala.Option[String] = None, state: scala.Option[ContainerServiceState] = None, stateDetail: scala.Option[ContainerServiceStateDetail] = None, scale: scala.Option[primitives.ContainerServiceScale] = None, currentDeployment: scala.Option[ContainerServiceDeployment] = None, nextDeployment: scala.Option[ContainerServiceDeployment] = None, isDisabled: scala.Option[Boolean] = None, principalArn: scala.Option[String] = None, privateDomainName: scala.Option[String] = None, publicDomainNames: scala.Option[Map[String, Iterable[String]]] = None, url: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContainerService = {
    import ContainerService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerService.builder().optionallyWith(containerServiceName.map(value => value: java.lang.String))(_.containerServiceName).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(power.map(value => value.unwrap))(_.power).optionallyWith(powerId.map(value => value: java.lang.String))(_.powerId).optionallyWith(state.map(value => value.unwrap))(_.state).optionallyWith(stateDetail.map(value => value.buildAwsValue()))(_.stateDetail).optionallyWith(scale.map(value => value: java.lang.Integer))(_.scale).optionallyWith(currentDeployment.map(value => value.buildAwsValue()))(_.currentDeployment).optionallyWith(nextDeployment.map(value => value.buildAwsValue()))(_.nextDeployment).optionallyWith(isDisabled.map(value => value: java.lang.Boolean))(_.isDisabled).optionallyWith(principalArn.map(value => value: java.lang.String))(_.principalArn).optionallyWith(privateDomainName.map(value => value: java.lang.String))(_.privateDomainName).optionallyWith(publicDomainNames.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.map { item => 
          item: java.lang.String
        }.asJavaCollection
    }).asJava))(_.publicDomainNames).optionallyWith(url.map(value => value: java.lang.String))(_.url).build()
  }
  def asReadOnly: ContainerService.ReadOnly = ContainerService.wrap(buildAwsValue())
}
object ContainerService {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContainerService] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContainerService = ContainerService(containerServiceNameValue.map(value => value), arnValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), powerValue.map(value => value), powerIdValue.map(value => value), stateValue.map(value => value), stateDetailValue.map(value => value.editable), scaleValue.map(value => value), currentDeploymentValue.map(value => value.editable), nextDeploymentValue.map(value => value.editable), isDisabledValue.map(value => value), principalArnValue.map(value => value), privateDomainNameValue.map(value => value), publicDomainNamesValue.map(value => value), urlValue.map(value => value))
    def containerServiceNameValue: scala.Option[primitives.ContainerServiceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def powerValue: scala.Option[ContainerServicePowerName]
    def powerIdValue: scala.Option[String]
    def stateValue: scala.Option[ContainerServiceState]
    def stateDetailValue: scala.Option[ContainerServiceStateDetail.ReadOnly]
    def scaleValue: scala.Option[primitives.ContainerServiceScale]
    def currentDeploymentValue: scala.Option[ContainerServiceDeployment.ReadOnly]
    def nextDeploymentValue: scala.Option[ContainerServiceDeployment.ReadOnly]
    def isDisabledValue: scala.Option[Boolean]
    def principalArnValue: scala.Option[String]
    def privateDomainNameValue: scala.Option[String]
    def publicDomainNamesValue: scala.Option[Map[String, List[String]]]
    def urlValue: scala.Option[String]
    def containerServiceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ContainerServiceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containerServiceName", containerServiceNameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def power: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServicePowerName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("power", powerValue)
    def powerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("powerId", powerIdValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def stateDetail: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceStateDetail.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("stateDetail", stateDetailValue)
    def scale: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ContainerServiceScale] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("scale", scaleValue)
    def currentDeployment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceDeployment.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentDeployment", currentDeploymentValue)
    def nextDeployment: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceDeployment.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextDeployment", nextDeploymentValue)
    def isDisabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isDisabled", isDisabledValue)
    def principalArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("principalArn", principalArnValue)
    def privateDomainName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("privateDomainName", privateDomainNameValue)
    def publicDomainNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[String, List[String]]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicDomainNames", publicDomainNamesValue)
    def url: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("url", urlValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContainerService) extends ContainerService.ReadOnly {
    override def containerServiceNameValue: scala.Option[primitives.ContainerServiceName] = scala.Option(impl.containerServiceName()).map(value => value: primitives.ContainerServiceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def powerValue: scala.Option[ContainerServicePowerName] = scala.Option(impl.power()).map(value => ContainerServicePowerName.wrap(value))
    override def powerIdValue: scala.Option[String] = scala.Option(impl.powerId()).map(value => value: String)
    override def stateValue: scala.Option[ContainerServiceState] = scala.Option(impl.state()).map(value => ContainerServiceState.wrap(value))
    override def stateDetailValue: scala.Option[ContainerServiceStateDetail.ReadOnly] = scala.Option(impl.stateDetail()).map(value => ContainerServiceStateDetail.wrap(value))
    override def scaleValue: scala.Option[primitives.ContainerServiceScale] = scala.Option(impl.scale()).map(value => value: primitives.ContainerServiceScale)
    override def currentDeploymentValue: scala.Option[ContainerServiceDeployment.ReadOnly] = scala.Option(impl.currentDeployment()).map(value => ContainerServiceDeployment.wrap(value))
    override def nextDeploymentValue: scala.Option[ContainerServiceDeployment.ReadOnly] = scala.Option(impl.nextDeployment()).map(value => ContainerServiceDeployment.wrap(value))
    override def isDisabledValue: scala.Option[Boolean] = scala.Option(impl.isDisabled()).map(value => value: Boolean)
    override def principalArnValue: scala.Option[String] = scala.Option(impl.principalArn()).map(value => value: String)
    override def privateDomainNameValue: scala.Option[String] = scala.Option(impl.privateDomainName()).map(value => value: String)
    override def publicDomainNamesValue: scala.Option[Map[String, List[String]]] = scala.Option(impl.publicDomainNames()).map(value => value.asScala.map({
      case (key, value) =>
        (key: String) -> value.asScala.map { item => 
          item: String
        }.toList
    }).toMap)
    override def urlValue: scala.Option[String] = scala.Option(impl.url()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContainerService): ReadOnly = new Wrapper(impl)
}