package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ContactMethodVerificationProtocol { def unwrap: software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol }
object ContactMethodVerificationProtocol {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol): ContactMethodVerificationProtocol = value match {
    case software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol.EMAIL =>
      val r = Email
      r
  }
  case object unknownToSdkVersion extends ContactMethodVerificationProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol = software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol.UNKNOWN_TO_SDK_VERSION }
  case object Email extends ContactMethodVerificationProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol = software.amazon.awssdk.services.lightsail.model.ContactMethodVerificationProtocol.EMAIL }
}