package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Bucket(resourceType: scala.Option[primitives.NonEmptyString] = None, accessRules: scala.Option[AccessRules] = None, arn: scala.Option[primitives.NonEmptyString] = None, bundleId: scala.Option[primitives.NonEmptyString] = None, createdAt: scala.Option[primitives.IsoDate] = None, url: scala.Option[primitives.NonEmptyString] = None, location: scala.Option[ResourceLocation] = None, name: scala.Option[primitives.BucketName] = None, supportCode: scala.Option[primitives.NonEmptyString] = None, tags: scala.Option[Iterable[Tag]] = None, objectVersioning: scala.Option[primitives.NonEmptyString] = None, ableToUpdateBundle: scala.Option[Boolean] = None, readonlyAccessAccounts: scala.Option[Iterable[primitives.NonEmptyString]] = None, resourcesReceivingAccess: scala.Option[Iterable[ResourceReceivingAccess]] = None, state: scala.Option[BucketState] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Bucket = {
    import Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Bucket.builder().optionallyWith(resourceType.map(value => value: java.lang.String))(_.resourceType).optionallyWith(accessRules.map(value => value.buildAwsValue()))(_.accessRules).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(bundleId.map(value => value: java.lang.String))(_.bundleId).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(url.map(value => value: java.lang.String))(_.url).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(objectVersioning.map(value => value: java.lang.String))(_.objectVersioning).optionallyWith(ableToUpdateBundle.map(value => value: java.lang.Boolean))(_.ableToUpdateBundle).optionallyWith(readonlyAccessAccounts.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.readonlyAccessAccounts).optionallyWith(resourcesReceivingAccess.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.resourcesReceivingAccess).optionallyWith(state.map(value => value.buildAwsValue()))(_.state).build()
  }
  def asReadOnly: Bucket.ReadOnly = Bucket.wrap(buildAwsValue())
}
object Bucket {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Bucket] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Bucket = Bucket(resourceTypeValue.map(value => value), accessRulesValue.map(value => value.editable), arnValue.map(value => value), bundleIdValue.map(value => value), createdAtValue.map(value => value), urlValue.map(value => value), locationValue.map(value => value.editable), nameValue.map(value => value), supportCodeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), objectVersioningValue.map(value => value), ableToUpdateBundleValue.map(value => value), readonlyAccessAccountsValue.map(value => value), resourcesReceivingAccessValue.map(value => value.map { item => 
      item.editable
    }), stateValue.map(value => value.editable))
    def resourceTypeValue: scala.Option[primitives.NonEmptyString]
    def accessRulesValue: scala.Option[AccessRules.ReadOnly]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def bundleIdValue: scala.Option[primitives.NonEmptyString]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def urlValue: scala.Option[primitives.NonEmptyString]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def nameValue: scala.Option[primitives.BucketName]
    def supportCodeValue: scala.Option[primitives.NonEmptyString]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def objectVersioningValue: scala.Option[primitives.NonEmptyString]
    def ableToUpdateBundleValue: scala.Option[Boolean]
    def readonlyAccessAccountsValue: scala.Option[List[primitives.NonEmptyString]]
    def resourcesReceivingAccessValue: scala.Option[List[ResourceReceivingAccess.ReadOnly]]
    def stateValue: scala.Option[BucketState.ReadOnly]
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def accessRules: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccessRules.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessRules", accessRulesValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def bundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def url: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("url", urlValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BucketName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def objectVersioning: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("objectVersioning", objectVersioningValue)
    def ableToUpdateBundle: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ableToUpdateBundle", ableToUpdateBundleValue)
    def readonlyAccessAccounts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.NonEmptyString]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readonlyAccessAccounts", readonlyAccessAccountsValue)
    def resourcesReceivingAccess: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ResourceReceivingAccess.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourcesReceivingAccess", resourcesReceivingAccessValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, BucketState.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Bucket) extends Bucket.ReadOnly {
    override def resourceTypeValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.resourceType()).map(value => value: primitives.NonEmptyString)
    override def accessRulesValue: scala.Option[AccessRules.ReadOnly] = scala.Option(impl.accessRules()).map(value => AccessRules.wrap(value))
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def bundleIdValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.bundleId()).map(value => value: primitives.NonEmptyString)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def urlValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.url()).map(value => value: primitives.NonEmptyString)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def nameValue: scala.Option[primitives.BucketName] = scala.Option(impl.name()).map(value => value: primitives.BucketName)
    override def supportCodeValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.supportCode()).map(value => value: primitives.NonEmptyString)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def objectVersioningValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.objectVersioning()).map(value => value: primitives.NonEmptyString)
    override def ableToUpdateBundleValue: scala.Option[Boolean] = scala.Option(impl.ableToUpdateBundle()).map(value => value: Boolean)
    override def readonlyAccessAccountsValue: scala.Option[List[primitives.NonEmptyString]] = scala.Option(impl.readonlyAccessAccounts()).map(value => value.asScala.map { item => 
      item: primitives.NonEmptyString
    }.toList)
    override def resourcesReceivingAccessValue: scala.Option[List[ResourceReceivingAccess.ReadOnly]] = scala.Option(impl.resourcesReceivingAccess()).map(value => value.asScala.map { item => 
      ResourceReceivingAccess.wrap(item)
    }.toList)
    override def stateValue: scala.Option[BucketState.ReadOnly] = scala.Option(impl.state()).map(value => BucketState.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Bucket): ReadOnly = new Wrapper(impl)
}