package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AutoSnapshotAddOnRequest(snapshotTimeOfDay: scala.Option[primitives.TimeOfDay] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest = {
    import AutoSnapshotAddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest.builder().optionallyWith(snapshotTimeOfDay.map(value => value: java.lang.String))(_.snapshotTimeOfDay).build()
  }
  def asReadOnly: AutoSnapshotAddOnRequest.ReadOnly = AutoSnapshotAddOnRequest.wrap(buildAwsValue())
}
object AutoSnapshotAddOnRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AutoSnapshotAddOnRequest = AutoSnapshotAddOnRequest(snapshotTimeOfDayValue.map(value => value))
    def snapshotTimeOfDayValue: scala.Option[primitives.TimeOfDay]
    def snapshotTimeOfDay: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TimeOfDay] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotTimeOfDay", snapshotTimeOfDayValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest) extends AutoSnapshotAddOnRequest.ReadOnly { override def snapshotTimeOfDayValue: scala.Option[primitives.TimeOfDay] = scala.Option(impl.snapshotTimeOfDay()).map(value => value: primitives.TimeOfDay) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotAddOnRequest): ReadOnly = new Wrapper(impl)
}