package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AttachLoadBalancerTlsCertificateRequest(loadBalancerName: primitives.ResourceName, certificateName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest = {
    import AttachLoadBalancerTlsCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).certificateName(certificateName: java.lang.String).build()
  }
  def asReadOnly: AttachLoadBalancerTlsCertificateRequest.ReadOnly = AttachLoadBalancerTlsCertificateRequest.wrap(buildAwsValue())
}
object AttachLoadBalancerTlsCertificateRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AttachLoadBalancerTlsCertificateRequest = AttachLoadBalancerTlsCertificateRequest(loadBalancerNameValue, certificateNameValue)
    def loadBalancerNameValue: primitives.ResourceName
    def certificateNameValue: primitives.ResourceName
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
    def certificateName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(certificateNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest) extends AttachLoadBalancerTlsCertificateRequest.ReadOnly {
    override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName
    override def certificateNameValue: primitives.ResourceName = impl.certificateName(): primitives.ResourceName
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AttachLoadBalancerTlsCertificateRequest): ReadOnly = new Wrapper(impl)
}