package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait AccessDirection { def unwrap: software.amazon.awssdk.services.lightsail.model.AccessDirection }
object AccessDirection {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.AccessDirection): AccessDirection = value match {
    case software.amazon.awssdk.services.lightsail.model.AccessDirection.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AccessDirection.INBOUND =>
      val r = inbound
      r
    case software.amazon.awssdk.services.lightsail.model.AccessDirection.OUTBOUND =>
      val r = outbound
      r
  }
  case object unknownToSdkVersion extends AccessDirection { override def unwrap: software.amazon.awssdk.services.lightsail.model.AccessDirection = software.amazon.awssdk.services.lightsail.model.AccessDirection.UNKNOWN_TO_SDK_VERSION }
  case object inbound extends AccessDirection { override def unwrap: software.amazon.awssdk.services.lightsail.model.AccessDirection = software.amazon.awssdk.services.lightsail.model.AccessDirection.INBOUND }
  case object outbound extends AccessDirection { override def unwrap: software.amazon.awssdk.services.lightsail.model.AccessDirection = software.amazon.awssdk.services.lightsail.model.AccessDirection.OUTBOUND }
}