package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateLoadBalancerAttributeRequest(loadBalancerName: primitives.ResourceName, attributeName: LoadBalancerAttributeName, attributeValue: primitives.StringMax256) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest = {
    import UpdateLoadBalancerAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).attributeName(attributeName.unwrap).attributeValue(attributeValue: java.lang.String).build()
  }
  def asReadOnly: UpdateLoadBalancerAttributeRequest.ReadOnly = UpdateLoadBalancerAttributeRequest.wrap(buildAwsValue())
}
object UpdateLoadBalancerAttributeRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateLoadBalancerAttributeRequest = UpdateLoadBalancerAttributeRequest(loadBalancerNameValue, attributeNameValue, attributeValueValue)
    def loadBalancerNameValue: primitives.ResourceName
    def attributeNameValue: LoadBalancerAttributeName
    def attributeValueValue: primitives.StringMax256
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
    def attributeName: ZIO[Any, Nothing, LoadBalancerAttributeName] = ZIO.succeed(attributeNameValue)
    def attributeValue: ZIO[Any, Nothing, primitives.StringMax256] = ZIO.succeed(attributeValueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest) extends UpdateLoadBalancerAttributeRequest.ReadOnly {
    override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName
    override def attributeNameValue: LoadBalancerAttributeName = LoadBalancerAttributeName.wrap(impl.attributeName())
    override def attributeValueValue: primitives.StringMax256 = impl.attributeValue(): primitives.StringMax256
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateLoadBalancerAttributeRequest): ReadOnly = new Wrapper(impl)
}