package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateBucketRequest(bucketName: primitives.BucketName, accessRules: scala.Option[AccessRules] = None, versioning: scala.Option[primitives.NonEmptyString] = None, readonlyAccessAccounts: scala.Option[Iterable[primitives.NonEmptyString]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest = {
    import UpdateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest.builder().bucketName(bucketName: java.lang.String).optionallyWith(accessRules.map(value => value.buildAwsValue()))(_.accessRules).optionallyWith(versioning.map(value => value: java.lang.String))(_.versioning).optionallyWith(readonlyAccessAccounts.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.readonlyAccessAccounts).build()
  }
  def asReadOnly: UpdateBucketRequest.ReadOnly = UpdateBucketRequest.wrap(buildAwsValue())
}
object UpdateBucketRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateBucketRequest = UpdateBucketRequest(bucketNameValue, accessRulesValue.map(value => value.editable), versioningValue.map(value => value), readonlyAccessAccountsValue.map(value => value))
    def bucketNameValue: primitives.BucketName
    def accessRulesValue: scala.Option[AccessRules.ReadOnly]
    def versioningValue: scala.Option[primitives.NonEmptyString]
    def readonlyAccessAccountsValue: scala.Option[List[primitives.NonEmptyString]]
    def bucketName: ZIO[Any, Nothing, primitives.BucketName] = ZIO.succeed(bucketNameValue)
    def accessRules: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, AccessRules.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessRules", accessRulesValue)
    def versioning: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("versioning", versioningValue)
    def readonlyAccessAccounts: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.NonEmptyString]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readonlyAccessAccounts", readonlyAccessAccountsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest) extends UpdateBucketRequest.ReadOnly {
    override def bucketNameValue: primitives.BucketName = impl.bucketName(): primitives.BucketName
    override def accessRulesValue: scala.Option[AccessRules.ReadOnly] = scala.Option(impl.accessRules()).map(value => AccessRules.wrap(value))
    override def versioningValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.versioning()).map(value => value: primitives.NonEmptyString)
    override def readonlyAccessAccountsValue: scala.Option[List[primitives.NonEmptyString]] = scala.Option(impl.readonlyAccessAccounts()).map(value => value.asScala.map { item => 
      item: primitives.NonEmptyString
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest): ReadOnly = new Wrapper(impl)
}