package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StaticIp(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, ipAddress: scala.Option[primitives.IpAddress] = None, attachedTo: scala.Option[primitives.ResourceName] = None, isAttached: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.StaticIp = {
    import StaticIp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StaticIp.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(ipAddress.map(value => value: java.lang.String))(_.ipAddress).optionallyWith(attachedTo.map(value => value: java.lang.String))(_.attachedTo).optionallyWith(isAttached.map(value => value: java.lang.Boolean))(_.isAttached).build()
  }
  def asReadOnly: StaticIp.ReadOnly = StaticIp.wrap(buildAwsValue())
}
object StaticIp {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.StaticIp] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StaticIp = StaticIp(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), ipAddressValue.map(value => value), attachedToValue.map(value => value), isAttachedValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def ipAddressValue: scala.Option[primitives.IpAddress]
    def attachedToValue: scala.Option[primitives.ResourceName]
    def isAttachedValue: scala.Option[Boolean]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def ipAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IpAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipAddress", ipAddressValue)
    def attachedTo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attachedTo", attachedToValue)
    def isAttached: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isAttached", isAttachedValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.StaticIp) extends StaticIp.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def ipAddressValue: scala.Option[primitives.IpAddress] = scala.Option(impl.ipAddress()).map(value => value: primitives.IpAddress)
    override def attachedToValue: scala.Option[primitives.ResourceName] = scala.Option(impl.attachedTo()).map(value => value: primitives.ResourceName)
    override def isAttachedValue: scala.Option[Boolean] = scala.Option(impl.isAttached()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.StaticIp): ReadOnly = new Wrapper(impl)
}