package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class PasswordData(ciphertext: scala.Option[String] = None, keyPairName: scala.Option[primitives.ResourceName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.PasswordData = {
    import PasswordData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PasswordData.builder().optionallyWith(ciphertext.map(value => value: java.lang.String))(_.ciphertext).optionallyWith(keyPairName.map(value => value: java.lang.String))(_.keyPairName).build()
  }
  def asReadOnly: PasswordData.ReadOnly = PasswordData.wrap(buildAwsValue())
}
object PasswordData {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.PasswordData] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: PasswordData = PasswordData(ciphertextValue.map(value => value), keyPairNameValue.map(value => value))
    def ciphertextValue: scala.Option[String]
    def keyPairNameValue: scala.Option[primitives.ResourceName]
    def ciphertext: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ciphertext", ciphertextValue)
    def keyPairName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyPairName", keyPairNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.PasswordData) extends PasswordData.ReadOnly {
    override def ciphertextValue: scala.Option[String] = scala.Option(impl.ciphertext()).map(value => value: String)
    override def keyPairNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.keyPairName()).map(value => value: primitives.ResourceName)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.PasswordData): ReadOnly = new Wrapper(impl)
}