package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class MetricDatapoint(average: scala.Option[Double] = None, maximum: scala.Option[Double] = None, minimum: scala.Option[Double] = None, sampleCount: scala.Option[Double] = None, sum: scala.Option[Double] = None, timestamp: scala.Option[primitives.Timestamp] = None, unit: scala.Option[MetricUnit] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.MetricDatapoint = {
    import MetricDatapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MetricDatapoint.builder().optionallyWith(average.map(value => value: java.lang.Double))(_.average).optionallyWith(maximum.map(value => value: java.lang.Double))(_.maximum).optionallyWith(minimum.map(value => value: java.lang.Double))(_.minimum).optionallyWith(sampleCount.map(value => value: java.lang.Double))(_.sampleCount).optionallyWith(sum.map(value => value: java.lang.Double))(_.sum).optionallyWith(timestamp.map(value => value: java.time.Instant))(_.timestamp).optionallyWith(unit.map(value => value.unwrap))(_.unit).build()
  }
  def asReadOnly: MetricDatapoint.ReadOnly = MetricDatapoint.wrap(buildAwsValue())
}
object MetricDatapoint {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.MetricDatapoint] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: MetricDatapoint = MetricDatapoint(averageValue.map(value => value), maximumValue.map(value => value), minimumValue.map(value => value), sampleCountValue.map(value => value), sumValue.map(value => value), timestampValue.map(value => value), unitValue.map(value => value))
    def averageValue: scala.Option[Double]
    def maximumValue: scala.Option[Double]
    def minimumValue: scala.Option[Double]
    def sampleCountValue: scala.Option[Double]
    def sumValue: scala.Option[Double]
    def timestampValue: scala.Option[primitives.Timestamp]
    def unitValue: scala.Option[MetricUnit]
    def average: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Double] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("average", averageValue)
    def maximum: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Double] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maximum", maximumValue)
    def minimum: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Double] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimum", minimumValue)
    def sampleCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Double] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sampleCount", sampleCountValue)
    def sum: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Double] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sum", sumValue)
    def timestamp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Timestamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timestamp", timestampValue)
    def unit: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, MetricUnit] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("unit", unitValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.MetricDatapoint) extends MetricDatapoint.ReadOnly {
    override def averageValue: scala.Option[Double] = scala.Option(impl.average()).map(value => value: Double)
    override def maximumValue: scala.Option[Double] = scala.Option(impl.maximum()).map(value => value: Double)
    override def minimumValue: scala.Option[Double] = scala.Option(impl.minimum()).map(value => value: Double)
    override def sampleCountValue: scala.Option[Double] = scala.Option(impl.sampleCount()).map(value => value: Double)
    override def sumValue: scala.Option[Double] = scala.Option(impl.sum()).map(value => value: Double)
    override def timestampValue: scala.Option[primitives.Timestamp] = scala.Option(impl.timestamp()).map(value => value: primitives.Timestamp)
    override def unitValue: scala.Option[MetricUnit] = scala.Option(impl.unit()).map(value => MetricUnit.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.MetricDatapoint): ReadOnly = new Wrapper(impl)
}