package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait LoadBalancerTlsCertificateStatus { def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus }
object LoadBalancerTlsCertificateStatus {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus): LoadBalancerTlsCertificateStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.PENDING_VALIDATION =>
      val r = PENDING_VALIDATION
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.ISSUED =>
      val r = ISSUED
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.EXPIRED =>
      val r = EXPIRED
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.VALIDATION_TIMED_OUT =>
      val r = VALIDATION_TIMED_OUT
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.REVOKED =>
      val r = REVOKED
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends LoadBalancerTlsCertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.UNKNOWN_TO_SDK_VERSION }
  case object PENDING_VALIDATION extends LoadBalancerTlsCertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.PENDING_VALIDATION }
  case object ISSUED extends LoadBalancerTlsCertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.ISSUED }
  case object INACTIVE extends LoadBalancerTlsCertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.INACTIVE }
  case object EXPIRED extends LoadBalancerTlsCertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.EXPIRED }
  case object VALIDATION_TIMED_OUT extends LoadBalancerTlsCertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.VALIDATION_TIMED_OUT }
  case object REVOKED extends LoadBalancerTlsCertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.REVOKED }
  case object FAILED extends LoadBalancerTlsCertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.FAILED }
  case object UNKNOWN extends LoadBalancerTlsCertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateStatus.UNKNOWN }
}