package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAlarmsRequest(alarmName: scala.Option[primitives.ResourceName] = None, pageToken: scala.Option[String] = None, monitoredResourceName: scala.Option[primitives.ResourceName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest = {
    import GetAlarmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest.builder().optionallyWith(alarmName.map(value => value: java.lang.String))(_.alarmName).optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).optionallyWith(monitoredResourceName.map(value => value: java.lang.String))(_.monitoredResourceName).build()
  }
  def asReadOnly: GetAlarmsRequest.ReadOnly = GetAlarmsRequest.wrap(buildAwsValue())
}
object GetAlarmsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAlarmsRequest = GetAlarmsRequest(alarmNameValue.map(value => value), pageTokenValue.map(value => value), monitoredResourceNameValue.map(value => value))
    def alarmNameValue: scala.Option[primitives.ResourceName]
    def pageTokenValue: scala.Option[String]
    def monitoredResourceNameValue: scala.Option[primitives.ResourceName]
    def alarmName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("alarmName", alarmNameValue)
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
    def monitoredResourceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoredResourceName", monitoredResourceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest) extends GetAlarmsRequest.ReadOnly {
    override def alarmNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.alarmName()).map(value => value: primitives.ResourceName)
    override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String)
    override def monitoredResourceNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.monitoredResourceName()).map(value => value: primitives.ResourceName)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest): ReadOnly = new Wrapper(impl)
}