package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DestinationInfo(id: scala.Option[primitives.NonEmptyString] = None, service: scala.Option[primitives.NonEmptyString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DestinationInfo = {
    import DestinationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DestinationInfo.builder().optionallyWith(id.map(value => value: java.lang.String))(_.id).optionallyWith(service.map(value => value: java.lang.String))(_.service).build()
  }
  def asReadOnly: DestinationInfo.ReadOnly = DestinationInfo.wrap(buildAwsValue())
}
object DestinationInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DestinationInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DestinationInfo = DestinationInfo(idValue.map(value => value), serviceValue.map(value => value))
    def idValue: scala.Option[primitives.NonEmptyString]
    def serviceValue: scala.Option[primitives.NonEmptyString]
    def id: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("id", idValue)
    def service: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("service", serviceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DestinationInfo) extends DestinationInfo.ReadOnly {
    override def idValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.id()).map(value => value: primitives.NonEmptyString)
    override def serviceValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.service()).map(value => value: primitives.NonEmptyString)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DestinationInfo): ReadOnly = new Wrapper(impl)
}