package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteDiskSnapshotRequest(diskSnapshotName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest = {
    import DeleteDiskSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest.builder().diskSnapshotName(diskSnapshotName: java.lang.String).build()
  }
  def asReadOnly: DeleteDiskSnapshotRequest.ReadOnly = DeleteDiskSnapshotRequest.wrap(buildAwsValue())
}
object DeleteDiskSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteDiskSnapshotRequest = DeleteDiskSnapshotRequest(diskSnapshotNameValue)
    def diskSnapshotNameValue: primitives.ResourceName
    def diskSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(diskSnapshotNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest) extends DeleteDiskSnapshotRequest.ReadOnly { override def diskSnapshotNameValue: primitives.ResourceName = impl.diskSnapshotName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskSnapshotRequest): ReadOnly = new Wrapper(impl)
}