package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDomainEntryRequest(domainName: primitives.DomainName, domainEntry: DomainEntry) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest = {
    import CreateDomainEntryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest.builder().domainName(domainName: java.lang.String).domainEntry(domainEntry.buildAwsValue()).build()
  }
  def asReadOnly: CreateDomainEntryRequest.ReadOnly = CreateDomainEntryRequest.wrap(buildAwsValue())
}
object CreateDomainEntryRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDomainEntryRequest = CreateDomainEntryRequest(domainNameValue, domainEntryValue.editable)
    def domainNameValue: primitives.DomainName
    def domainEntryValue: DomainEntry.ReadOnly
    def domainName: ZIO[Any, Nothing, primitives.DomainName] = ZIO.succeed(domainNameValue)
    def domainEntry: ZIO[Any, Nothing, DomainEntry.ReadOnly] = ZIO.succeed(domainEntryValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest) extends CreateDomainEntryRequest.ReadOnly {
    override def domainNameValue: primitives.DomainName = impl.domainName(): primitives.DomainName
    override def domainEntryValue: DomainEntry.ReadOnly = DomainEntry.wrap(impl.domainEntry())
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest): ReadOnly = new Wrapper(impl)
}