package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ContainerServiceDeploymentState { def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState }
object ContainerServiceDeploymentState {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState): ContainerServiceDeploymentState = value match {
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.ACTIVATING =>
      val r = ACTIVATING
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends ContainerServiceDeploymentState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState = software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.UNKNOWN_TO_SDK_VERSION }
  case object ACTIVATING extends ContainerServiceDeploymentState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState = software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.ACTIVATING }
  case object ACTIVE extends ContainerServiceDeploymentState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState = software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.ACTIVE }
  case object INACTIVE extends ContainerServiceDeploymentState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState = software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.INACTIVE }
  case object FAILED extends ContainerServiceDeploymentState { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState = software.amazon.awssdk.services.lightsail.model.ContainerServiceDeploymentState.FAILED }
}