package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ContactMethodStatus { def unwrap: software.amazon.awssdk.services.lightsail.model.ContactMethodStatus }
object ContactMethodStatus {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ContactMethodStatus): ContactMethodStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.ContactMethodStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ContactMethodStatus.PENDING_VERIFICATION =>
      val r = PendingVerification
      r
    case software.amazon.awssdk.services.lightsail.model.ContactMethodStatus.VALID =>
      val r = Valid
      r
    case software.amazon.awssdk.services.lightsail.model.ContactMethodStatus.INVALID =>
      val r = Invalid
      r
  }
  case object unknownToSdkVersion extends ContactMethodStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContactMethodStatus = software.amazon.awssdk.services.lightsail.model.ContactMethodStatus.UNKNOWN_TO_SDK_VERSION }
  case object PendingVerification extends ContactMethodStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContactMethodStatus = software.amazon.awssdk.services.lightsail.model.ContactMethodStatus.PENDING_VERIFICATION }
  case object Valid extends ContactMethodStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContactMethodStatus = software.amazon.awssdk.services.lightsail.model.ContactMethodStatus.VALID }
  case object Invalid extends ContactMethodStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.ContactMethodStatus = software.amazon.awssdk.services.lightsail.model.ContactMethodStatus.INVALID }
}