package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait ComparisonOperator { def unwrap: software.amazon.awssdk.services.lightsail.model.ComparisonOperator }
object ComparisonOperator {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.ComparisonOperator): ComparisonOperator = value match {
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD =>
      val r = GreaterThanOrEqualToThreshold
      r
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.GREATER_THAN_THRESHOLD =>
      val r = GreaterThanThreshold
      r
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.LESS_THAN_THRESHOLD =>
      val r = LessThanThreshold
      r
    case software.amazon.awssdk.services.lightsail.model.ComparisonOperator.LESS_THAN_OR_EQUAL_TO_THRESHOLD =>
      val r = LessThanOrEqualToThreshold
      r
  }
  case object unknownToSdkVersion extends ComparisonOperator { override def unwrap: software.amazon.awssdk.services.lightsail.model.ComparisonOperator = software.amazon.awssdk.services.lightsail.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION }
  case object GreaterThanOrEqualToThreshold extends ComparisonOperator { override def unwrap: software.amazon.awssdk.services.lightsail.model.ComparisonOperator = software.amazon.awssdk.services.lightsail.model.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD }
  case object GreaterThanThreshold extends ComparisonOperator { override def unwrap: software.amazon.awssdk.services.lightsail.model.ComparisonOperator = software.amazon.awssdk.services.lightsail.model.ComparisonOperator.GREATER_THAN_THRESHOLD }
  case object LessThanThreshold extends ComparisonOperator { override def unwrap: software.amazon.awssdk.services.lightsail.model.ComparisonOperator = software.amazon.awssdk.services.lightsail.model.ComparisonOperator.LESS_THAN_THRESHOLD }
  case object LessThanOrEqualToThreshold extends ComparisonOperator { override def unwrap: software.amazon.awssdk.services.lightsail.model.ComparisonOperator = software.amazon.awssdk.services.lightsail.model.ComparisonOperator.LESS_THAN_OR_EQUAL_TO_THRESHOLD }
}