package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait AccessType { def unwrap: software.amazon.awssdk.services.lightsail.model.AccessType }
object AccessType {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.AccessType): AccessType = value match {
    case software.amazon.awssdk.services.lightsail.model.AccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.AccessType.PUBLIC =>
      val r = public
      r
    case software.amazon.awssdk.services.lightsail.model.AccessType.PRIVATE =>
      val r = `private`
      r
  }
  case object unknownToSdkVersion extends AccessType { override def unwrap: software.amazon.awssdk.services.lightsail.model.AccessType = software.amazon.awssdk.services.lightsail.model.AccessType.UNKNOWN_TO_SDK_VERSION }
  case object public extends AccessType { override def unwrap: software.amazon.awssdk.services.lightsail.model.AccessType = software.amazon.awssdk.services.lightsail.model.AccessType.PUBLIC }
  case object `private` extends AccessType { override def unwrap: software.amazon.awssdk.services.lightsail.model.AccessType = software.amazon.awssdk.services.lightsail.model.AccessType.PRIVATE }
}