package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StartRelationalDatabaseRequest(relationalDatabaseName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest = {
    import StartRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).build()
  }
  def asReadOnly: StartRelationalDatabaseRequest.ReadOnly = StartRelationalDatabaseRequest.wrap(buildAwsValue())
}
object StartRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StartRelationalDatabaseRequest = StartRelationalDatabaseRequest(relationalDatabaseNameValue)
    def relationalDatabaseNameValue: primitives.ResourceName
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest) extends StartRelationalDatabaseRequest.ReadOnly { override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.StartRelationalDatabaseRequest): ReadOnly = new Wrapper(impl)
}