package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstanceAccessDetails(certKey: scala.Option[String] = None, expiresAt: scala.Option[primitives.IsoDate] = None, ipAddress: scala.Option[primitives.IpAddress] = None, password: scala.Option[String] = None, passwordData: scala.Option[PasswordData] = None, privateKey: scala.Option[String] = None, protocol: scala.Option[InstanceAccessProtocol] = None, instanceName: scala.Option[primitives.ResourceName] = None, username: scala.Option[String] = None, hostKeys: scala.Option[Iterable[HostKeyAttributes]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails = {
    import InstanceAccessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails.builder().optionallyWith(certKey.map(value => value: java.lang.String))(_.certKey).optionallyWith(expiresAt.map(value => value: java.time.Instant))(_.expiresAt).optionallyWith(ipAddress.map(value => value: java.lang.String))(_.ipAddress).optionallyWith(password.map(value => value: java.lang.String))(_.password).optionallyWith(passwordData.map(value => value.buildAwsValue()))(_.passwordData).optionallyWith(privateKey.map(value => value: java.lang.String))(_.privateKey).optionallyWith(protocol.map(value => value.unwrap))(_.protocol).optionallyWith(instanceName.map(value => value: java.lang.String))(_.instanceName).optionallyWith(username.map(value => value: java.lang.String))(_.username).optionallyWith(hostKeys.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.hostKeys).build()
  }
  def asReadOnly: InstanceAccessDetails.ReadOnly = InstanceAccessDetails.wrap(buildAwsValue())
}
object InstanceAccessDetails {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstanceAccessDetails = InstanceAccessDetails(certKeyValue.map(value => value), expiresAtValue.map(value => value), ipAddressValue.map(value => value), passwordValue.map(value => value), passwordDataValue.map(value => value.editable), privateKeyValue.map(value => value), protocolValue.map(value => value), instanceNameValue.map(value => value), usernameValue.map(value => value), hostKeysValue.map(value => value.map { item => 
      item.editable
    }))
    def certKeyValue: scala.Option[String]
    def expiresAtValue: scala.Option[primitives.IsoDate]
    def ipAddressValue: scala.Option[primitives.IpAddress]
    def passwordValue: scala.Option[String]
    def passwordDataValue: scala.Option[PasswordData.ReadOnly]
    def privateKeyValue: scala.Option[String]
    def protocolValue: scala.Option[InstanceAccessProtocol]
    def instanceNameValue: scala.Option[primitives.ResourceName]
    def usernameValue: scala.Option[String]
    def hostKeysValue: scala.Option[List[HostKeyAttributes.ReadOnly]]
    def certKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certKey", certKeyValue)
    def expiresAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expiresAt", expiresAtValue)
    def ipAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IpAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipAddress", ipAddressValue)
    def password: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("password", passwordValue)
    def passwordData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PasswordData.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("passwordData", passwordDataValue)
    def privateKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("privateKey", privateKeyValue)
    def protocol: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceAccessProtocol] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("protocol", protocolValue)
    def instanceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceName", instanceNameValue)
    def username: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("username", usernameValue)
    def hostKeys: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[HostKeyAttributes.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hostKeys", hostKeysValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails) extends InstanceAccessDetails.ReadOnly {
    override def certKeyValue: scala.Option[String] = scala.Option(impl.certKey()).map(value => value: String)
    override def expiresAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.expiresAt()).map(value => value: primitives.IsoDate)
    override def ipAddressValue: scala.Option[primitives.IpAddress] = scala.Option(impl.ipAddress()).map(value => value: primitives.IpAddress)
    override def passwordValue: scala.Option[String] = scala.Option(impl.password()).map(value => value: String)
    override def passwordDataValue: scala.Option[PasswordData.ReadOnly] = scala.Option(impl.passwordData()).map(value => PasswordData.wrap(value))
    override def privateKeyValue: scala.Option[String] = scala.Option(impl.privateKey()).map(value => value: String)
    override def protocolValue: scala.Option[InstanceAccessProtocol] = scala.Option(impl.protocol()).map(value => InstanceAccessProtocol.wrap(value))
    override def instanceNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.instanceName()).map(value => value: primitives.ResourceName)
    override def usernameValue: scala.Option[String] = scala.Option(impl.username()).map(value => value: String)
    override def hostKeysValue: scala.Option[List[HostKeyAttributes.ReadOnly]] = scala.Option(impl.hostKeys()).map(value => value.asScala.map { item => 
      HostKeyAttributes.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails): ReadOnly = new Wrapper(impl)
}