package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseResponse(relationalDatabase: scala.Option[RelationalDatabase] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse = {
    import GetRelationalDatabaseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse.builder().optionallyWith(relationalDatabase.map(value => value.buildAwsValue()))(_.relationalDatabase).build()
  }
  def asReadOnly: GetRelationalDatabaseResponse.ReadOnly = GetRelationalDatabaseResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseResponse = GetRelationalDatabaseResponse(relationalDatabaseValue.map(value => value.editable))
    def relationalDatabaseValue: scala.Option[RelationalDatabase.ReadOnly]
    def relationalDatabase: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RelationalDatabase.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabase", relationalDatabaseValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse) extends GetRelationalDatabaseResponse.ReadOnly { override def relationalDatabaseValue: scala.Option[RelationalDatabase.ReadOnly] = scala.Option(impl.relationalDatabase()).map(value => RelationalDatabase.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseResponse): ReadOnly = new Wrapper(impl)
}