package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseLogEventsRequest(relationalDatabaseName: primitives.ResourceName, logStreamName: String, startTime: scala.Option[primitives.IsoDate] = None, endTime: scala.Option[primitives.IsoDate] = None, startFromHead: scala.Option[Boolean] = None, pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest = {
    import GetRelationalDatabaseLogEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).logStreamName(logStreamName: java.lang.String).optionallyWith(startTime.map(value => value: java.time.Instant))(_.startTime).optionallyWith(endTime.map(value => value: java.time.Instant))(_.endTime).optionallyWith(startFromHead.map(value => value: java.lang.Boolean))(_.startFromHead).optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetRelationalDatabaseLogEventsRequest.ReadOnly = GetRelationalDatabaseLogEventsRequest.wrap(buildAwsValue())
}
object GetRelationalDatabaseLogEventsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseLogEventsRequest = GetRelationalDatabaseLogEventsRequest(relationalDatabaseNameValue, logStreamNameValue, startTimeValue.map(value => value), endTimeValue.map(value => value), startFromHeadValue.map(value => value), pageTokenValue.map(value => value))
    def relationalDatabaseNameValue: primitives.ResourceName
    def logStreamNameValue: String
    def startTimeValue: scala.Option[primitives.IsoDate]
    def endTimeValue: scala.Option[primitives.IsoDate]
    def startFromHeadValue: scala.Option[Boolean]
    def pageTokenValue: scala.Option[String]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def logStreamName: ZIO[Any, Nothing, String] = ZIO.succeed(logStreamNameValue)
    def startTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("startTime", startTimeValue)
    def endTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endTime", endTimeValue)
    def startFromHead: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("startFromHead", startFromHeadValue)
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest) extends GetRelationalDatabaseLogEventsRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def logStreamNameValue: String = impl.logStreamName(): String
    override def startTimeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.startTime()).map(value => value: primitives.IsoDate)
    override def endTimeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.endTime()).map(value => value: primitives.IsoDate)
    override def startFromHeadValue: scala.Option[Boolean] = scala.Option(impl.startFromHead()).map(value => value: Boolean)
    override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsRequest): ReadOnly = new Wrapper(impl)
}