package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetOperationRequest(operationId: primitives.NonEmptyString) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetOperationRequest = {
    import GetOperationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationRequest.builder().operationId(operationId: java.lang.String).build()
  }
  def asReadOnly: GetOperationRequest.ReadOnly = GetOperationRequest.wrap(buildAwsValue())
}
object GetOperationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetOperationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetOperationRequest = GetOperationRequest(operationIdValue)
    def operationIdValue: primitives.NonEmptyString
    def operationId: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(operationIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetOperationRequest) extends GetOperationRequest.ReadOnly { override def operationIdValue: primitives.NonEmptyString = impl.operationId(): primitives.NonEmptyString }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetOperationRequest): ReadOnly = new Wrapper(impl)
}