package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLoadBalancerTlsCertificatesResponse(tlsCertificates: scala.Option[Iterable[LoadBalancerTlsCertificate]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse = {
    import GetLoadBalancerTlsCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse.builder().optionallyWith(tlsCertificates.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tlsCertificates).build()
  }
  def asReadOnly: GetLoadBalancerTlsCertificatesResponse.ReadOnly = GetLoadBalancerTlsCertificatesResponse.wrap(buildAwsValue())
}
object GetLoadBalancerTlsCertificatesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLoadBalancerTlsCertificatesResponse = GetLoadBalancerTlsCertificatesResponse(tlsCertificatesValue.map(value => value.map { item => 
      item.editable
    }))
    def tlsCertificatesValue: scala.Option[List[LoadBalancerTlsCertificate.ReadOnly]]
    def tlsCertificates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LoadBalancerTlsCertificate.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tlsCertificates", tlsCertificatesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse) extends GetLoadBalancerTlsCertificatesResponse.ReadOnly {
    override def tlsCertificatesValue: scala.Option[List[LoadBalancerTlsCertificate.ReadOnly]] = scala.Option(impl.tlsCertificates()).map(value => value.asScala.map { item => 
      LoadBalancerTlsCertificate.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesResponse): ReadOnly = new Wrapper(impl)
}